#include <bits/stdc++.h>
using namespace std;

using ll = long long;
const long double INF = 1e30;

struct Mast {
    ll x, h;
    int id;
};

long double dist(ll x1, ll y1, ll x2, ll y2) {
    long double dx = x1 - x2;
    long double dy = y1 - y2;
    return sqrt(dx * dx + dy * dy);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<Mast> a(n);
    for (int i = 0; i < n; i++) cin >> a[i].x;
    for (int i = 0; i < n; i++) {
        cin >> a[i].h;
        a[i].id = i;
    }

    sort(a.begin(), a.end(), [](auto &p, auto &q) {
        return p.x < q.x;
    });

    vector<long double> ans(n, INF);

    for (int i = 0; i + 1 < n; i++) {
        ll x1 = a[i].x, h1 = a[i].h;
        ll x2 = a[i + 1].x, h2 = a[i + 1].h;

        ll px = (x1 + x2 + h1 - h2) / 2;
        ll py = h1 - (px - x1);

        for (int t = 0; t < 2; t++) {
            int j = (t == 0 ? i : i + 1);
            ll hx = a[j].x;
            ll hh = a[j].h;

            if (py >= hh) {
                ans[a[j].id] = min(ans[a[j].id],
                    dist(hx, hh, px, py));
            }
        }
    }

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            if (i == j) continue;
            if (a[j].h >= a[i].h) {
                ans[a[i].id] = min(ans[a[i].id],
                    dist(a[i].x, a[i].h, a[j].x, a[j].h));
            }
        }
    }

    for (int i = 0; i < n; i++) {
        if (ans[i] > 1e29) cout << -1 << "\n";
        else cout << fixed << setprecision(0) << ans[i] << "\n";
    }

    return 0;
}